-- file not used: not localized

--PhysX Material System.

--PhysX Material Type defination----------------------------------------------------------------------------------------------------
--Rigid body material type. 
struct PxRBMtl
(
	--Material property members.
	_density = undefined,
	_mass = undefined,
	_staticFriction = undefined,
	_dynamicFriction = undefined,
	_bounciness = undefined
	
)

--Clothing physical material type. 
struct PxClothMtl
(
	--Material property members.
	_antiStretch = undefined,
	_density = undefined,
	_friction = undefined,
	_stretchStiffness = undefined,
	_bendingStiffness = undefined,
	_dampingCoefficient = undefined,
	_maxDistanceBias = undefined,
	_selfCollideThickness = undefined,
	_antiStretchFactor = undefined
)

--Random Material ID generating------------------------------------------------------------------------------------------------------
/*!
The PhysX Material ID is a 20 digit decimal number string which represents number from 0 to 10^20-1.
e.g. 62728935345243704694
*/
fn GenMtlID = 
(
	strResult = ""
	local nDig = 0
	
	for i=1 to 20 do
	(
		nDig = random 0 9
		strResult += nDig as string
	)
	
	strResult
)

--PhysX Material Sub-group defination-----------------------------------------------------------------------------------------------
--Material Global & Native enums.
global EM_GLOBAL = 1
global EM_NATIVE = 2

--Root material groups
global gAryRootGroups = #( "Global", "Native" )

--Material type enums.
global EM_RB = 1
global EM_CLOTH = 2

--Material name attay.
global gAryMtlTypeNames = #()
gAryMtlTypeNames[EM_RB] = "Rigid Body"
gAryMtlTypeNames[EM_CLOTH] = "Cloth"

--RB Materials Sub-group enums.
global EM_NATURALMTL = 1
global EM_WOODS = 2
global EM_MASONRYNSTONE = 3

--RB Materials Sub-group name array.
global gAryRBSubGroupNames = #()
gAryRBSubGroupNames[EM_NATURALMTL] = "Natural Materials"
gAryRBSubGroupNames[EM_WOODS] = "Woods"
gAryRBSubGroupNames[EM_MASONRYNSTONE] = "Masonry and Stone"

--Cloth Materials Sub-group enums.
global EM_SILK = 1
global EM_FIBER = 2

--Cloth Materials Sub-group name array.
global gAryClothSubGroupNames = #()
gAryClothSubGroupNames[EM_SILK] = "Silk"
gAryClothSubGroupNames[EM_FIBER] = "Fiber"

--Store all native material here.
persistent global gAryNativeMtls = #()

--PhysX Material----------------------------------------------------------------------------------------------------------------------------
struct PxMtl
(
	--Physical Material Type.
	_mtlType = undefined,
	
	--Category used to sub-group materials.
	_category = 1,
	
	--Human-friendly display name.
	_name = "",
	
	--Unique internal identifier. temporarily using genClassID().
	_mtlID = undefined,
	
	--Material data.
	_data = undefined,
	
	--Editable or not.
	_bEditable = true,
	
	--Export this to user specified *.TBD file.
	fn ExportToTBD strFileName = 
	(
		local strSection = _mtlID as string
		
		local curString = _mtlType as string
		setINISetting strFileName strSection "Type" curString
		curString = _category as string
		setINISetting strFileName strSection "SubGroup" curString
		curString = _name as string
		setINISetting strFileName strSection "Name" curString
		curString = _mtlID as string
		setINISetting strFileName strSection "ID" curString
		
		case _mtlType of
		(
			EM_RB:
			(
				local curString = _data._density as string
				setINISetting strFileName strSection "Density" curString
				local curString = _data._mass as string
				setINISetting strFileName strSection "Mass" curString
				local curString = _data._staticFriction as string
				setINISetting strFileName strSection "StaticFriction" curString
				local curString = _data._dynamicFriction as string
				setINISetting strFileName strSection "DynamicFriction" curString
				local curString = _data._bounciness as string
				setINISetting strFileName strSection "Bounciness" curString
			)
			EM_CLOTH:
			(
				local curString = _data._antiStretch as string
				setINISetting strFileName strSection "AntiStretch" curString
				local curString = _data._density as string
				setINISetting strFileName strSection "Density" curString
				local curString = _data._friction as string
				setINISetting strFileName strSection "Friction" curString
				local curString = _data._stretchStiffness as string
				setINISetting strFileName strSection "StretchStiffness" curString
				local curString = _data._bendingStiffness as string
				setINISetting strFileName strSection "BendingStiffness" curString
				local curString = _data._dampingCoefficient as string
				setINISetting strFileName strSection "DampingCoefficient" curString
				local curString = _data._maxDistanceBias as string
				setINISetting strFileName strSection "MaxDistanceBias" curString
				local curString = _data._selfCollideThickness as string
				setINISetting strFileName strSection "SelfCollideThickness" curString
				local curString = _data._antiStretchFactor as string
				setINISetting strFileName strSection "AntiStretchFactor" curString
			)
		)
	),
	
	--Serialize to current *.max file.
	fn SaveInCurMaxFile = 
	(
		if gAryNativeMtls==undefined then false
		else
		(
			local dataItem = #()
			
			--Position in item data array 1-4
			append dataItem _mtlType
			append dataItem _category
			append dataItem _name
			append dataItem _mtlID
			
			--Position in item data array from 5-end
			case _mtlType of
			(
				EM_RB:
				(
					append dataItem _data._density
					append dataItem _data._mass
					append dataItem _data._staticFriction
					append dataItem _data._dynamicFriction
					append dataItem _data._Bounciness
				)
				EM_CLOTH:
				(
					append dataItem _data._antiStretch
					append dataItem _data._density
					append dataItem _data._friction
					append dataItem _data._stretchStiffness
					append dataItem _data._bendingStiffness
					append dataItem _data._dampingCoefficient
					append dataItem _data._maxDistanceBias
					append dataItem _data._selfCollideThickness
					append dataItem _data._antiStretchFactor
				)
			)
			
			--Save one item data array in persistant global array.
			append gAryNativeMtls dataItem
			true
		)
	),
	
	--Apply in current *.max file
	fn ApplyInCurMaxFile =
	(
		if gAryNativeMtls==undefined then false
		else
		(
			for i=1 to gAryNativeMtls.count do
			(
				/*print gAryNativeMtls[i][4]
				print _mtlID
				print "----------------------------------------"*/
				if gAryNativeMtls[i][4]==_mtlID do
				(
					deleteItem gAryNativeMtls i
					SaveInCurMaxFile()
				)
			)
		)
	),
	
	--Remove in current *.max file
	fn RemoveInCurMaxFile =
	(
		if gAryNativeMtls==undefined then  false
		else
		(
			ret = false
			for i=1 to gAryNativeMtls.count do
			(
				if gAryNativeMtls[i][4]==_mtlID do
				(
					deleteItem gAryNativeMtls i
					ret = true
					exit
				)
			)
			ret
		)
	)
)

--PhysX Material manager---------------------------------------------------------------------------------------------------------------
--Material manager
struct PxMtlManager
(
	--Store all global Mtls
	_aryGlobalMtls = #(),
	
	--Store all native Mtls
	_aryNativeMtls = #(),
	
	--Test if material with specified ID in global material set
	fn IsMtlInGlobalSet iID= 
	(
		if _aryGlobalMtls==#() then false
		else
		(
			ret = false
			for i in _aryGlobalMtls do
			(
				if i._mtlID==iID then
				(
					ret = true
					exit
				)
			)
			ret
		)
	),
	
	--Remove material with specified ID from native material set
	fn RemoveMtlInNativeSet iID= 
	(
		if _aryNativeMtls==#() or iID=="" then false
		else
		(
			ret = false
			for i=1 to _aryNativeMtls.count do
			(
				if _aryNativeMtls[i]._mtlID==iID do
				(
					deleteItem _aryNativeMtls i
					ret = true
					exit
				)
			)
			ret
		)
	),
	
	--Append unique items
	fn AppendItemUnique iMtl bGlobal:false = 
	(
		isUnique = true
		if bGlobal==false then
		(
			for i in _aryNativeMtls do
			(
				if i._mtlID==iMtl._mtlID then
				(
					isUnique = false
					exit
				)
			)
			if isUnique then append _aryNativeMtls iMtl
		)
		else
		(
			for i in _aryGlobalMtls do
			(
				if i._mtlID==iMtl._mtlID then
				(
					isUnique = false
					exit
				)
			)
			if isUnique then append _aryGlobalMtls iMtl
		)
		isUnique
	)
)

global g_PxMtlManager = PxMtlManager()

--Global Funcs for Work flow---------------------------------------------------------------------------------------------------------------
--Load all native materials from current *.max file.
fn LoadAllNativeMtls = 
(
	if gAryNativeMtls == #() then false
	else
	(
		for i in gAryNativeMtls do
		(
			local mtlData = undefined
			local newMtl = undefined
				
			case i[1] of
			(
				EM_RB:
				(
					--Fill in material type data.
					mtlData = PxRBMtl()
					mtlData._density = i[5]
					mtlData._mass = i[6]
					mtlData._staticFriction = i[7]
					mtlData._dynamicFriction = i[8]
					mtlData._bounciness = i[9]
				)
				EM_CLOTH:
				(
					mtlData = PxClothMtl()
					mtlData._antiStretch = i[5]
					mtlData._density = i[6]
					mtlData._friction = i[7]
					mtlData._stretchStiffness = i[8]
					mtlData._bendingStiffness = i[9]
					mtlData._dampingCoefficient = i[10]
					mtlData._maxDistanceBias = i[11]
					mtlData._selfCollideThickness = i[12]
					mtlData._antiStretchFactor = i[13]
				)
			)
				
			--Create material.
			newMtl = PxMtl() 
			newMtl._mtlType = i[1]
			newMtl._category = i[2]
			newMtl._name = i[3]
			newMtl._mtlID = i[4]
			newMtl._data = mtlData
			newMtl._bEditable = true
				
			--Insert into PhysX material data manager
			g_PxMtlManager.AppendItemUnique newMtl
		)
		true
	)
)

--Save specified material into a user choosen *.TBD file
--For testing funcs, just save all materials in the memory :)
fn SaveMtlsToTBD iArySerial:#() = 
(
	local dir = nvpx.GetMaterialPath() + @"\"
	local filename = getSaveFileName caption:"PhysX Material File" types:"PhysX Material (*.TBD)|*.TBD|All Files (*.*)|*.*|" historyCategory:"PhysX Materials" filename:dir
	
	if filename == undefined then false
	else
	(
		for i in g_PxMtlManager._aryNativeMtls do
		(
			i.ExportToTBD filename
		)
		true
	)
)

--get data value from specified INI section & key.
fn getValueFromTBD strFile strSection strKey = 
(
	local strContent = GetINISetting strFile strSection strKey
	local strStream = stringstream strContent
	seek strStream 0
	result = readvalue strStream
)

--PhysX materials importing
/*!
1).Load all global materials from global_materials.TBD
2).Load materials from a specified *.TBD
*/

fn ImportMaterials bGlobal:true dir:"" = 
(
	if bGlobal==true then
	(
		dir = GetDir #scripts
		dir +="\\nvpx\\global_materials.TBD"
	)
	
	arySections = getINISetting dir
	if arySections == "" or arySections == #() do
	(
		messagebox "Can't find global materials!" title:"Warning"
		false
	)
	else
	(
		for i in arySections do
		(
			--Create material.
			newMtl = PxMtl()
			newMtl._mtlType = getValueFromTBD dir i "Type"
			newMtl._category = getValueFromTBD dir i "SubGroup"
			newMtl._name = getINISetting dir i "Name"
			newMtl._mtlID = getINISetting dir i "ID"
			newMtl._bEditable = false
			
			case newMtl._mtlType of
			(
				EM_RB:
				(
					newMtl._data = PxRBMtl()
					newMtl._data._density = getValueFromTBD dir i "Density"
					newMtl._data._mass = getValueFromTBD dir i "Mass"
					newMtl._data._staticFriction = getValueFromTBD dir i "StaticFriction"
					newMtl._data._dynamicFriction = getValueFromTBD dir i "DynamicFriction"
					newMtl._data._bounciness = getValueFromTBD dir i "Bounciness"
				)
				EM_CLOTH:
				(
					newMtl._data = PxClothMtl()
					newMtl._data._antiStretch = getValueFromTBD dir i "AntiStretch"
					newMtl._data._density = getValueFromTBD dir i "Density"
					newMtl._data._friction = getValueFromTBD dir i "Friction"
					newMtl._data._stretchStiffness = getValueFromTBD dir i "StretchStiffness"
					newMtl._data._bendingStiffness = getValueFromTBD dir i "BendingStiffness"
					newMtl._data._dampingCoefficient = getValueFromTBD dir i "DampingCoefficient"
					newMtl._data._maxDistanceBias = getValueFromTBD dir i "MaxDistanceBias"
					newMtl._data._selfCollideThickness = getValueFromTBD dir i "SelfCollideThickness"
					newMtl._data._antiStretchFactor = getValueFromTBD dir i "AntiStretchFactor"
				)
			)
			
			if bGlobal==true then
			(
				--Save new created material in PhysX material data manager.
				g_PxMtlManager.AppendItemUnique newMtl bGlobal:true
			)
			else
			(
				--Import to native data manager
				g_PxMtlManager.AppendItemUnique newMtl
			)
		)
		
		true
	)
)

/*--Creation Settings rollout.
rollout RolloutCreation "Creation New Material"
(
	button bn_creation "Create Material" align:#center
	
	on bn_creation pressed do
	(
		newMtl = CreateOneNativeMtl()
		print newMtl
		
		--Save new created material in PhysX material data manager.
		append g_PxMtlManager._aryNativeMtls newMtl
		
		--Save in current *.max file.
		newMtl.SaveInCurMaxFile()
	)
)*/

--Call backs--------------------------------------------------------------------------------------------------------------------------
--callbacks.addscript #preSystemShutdown "persistent global gAryNativeMtls" id:#persistantVals

--UI for testing---------------------------------------------------------------------------------------------------------------------
rollout TestUI "PhysX Material System Test UI" width:800 height:600
(
	--UI defs.
	groupBox grp2 "GroupBox" pos:[574,492] width:0 height:0
	groupBox gr_RB "Rigid Body Material" pos:[9,210] width:260 height:320
	groupBox gr_cloth "Cloth Material" pos:[280,210] width:260 height:320
	listBox lb_global "Global" pos:[10,10] width:260 height:12
	listBox lb_native "In Project" pos:[280,10] width:260 height:12
	button bt_import "import materials" pos:[10,570] width:100 height:20
	button bt_export "export materials" pos:[118,570] width:100 height:20
	button bt_create_rb "create RB material" pos:[10,543] width:110 height:18
	button bt_remove "remove" pos:[487,543] width:110 height:18
	button bt_apply_rb "apply RB changes" pos:[248,543] width:110 height:18
	groupBox gr_association "Association" pos:[550,23] width:243 height:506
	button bt_rb_on "associate current RB" pos:[556,173] width:110 height:20
	button bt_rb_off "remove RB" pos:[675,173] width:110 height:20
	button bt_rs_on "associate current RS" pos:[556,205] width:110 height:20
	button bt_rs_off "remove RS" pos:[675,205] width:110 height:20
	button bt_rg_on "associate current RG" pos:[556,237] width:110 height:20
	button bt_rg_off "remove RG" pos:[675,237] width:110 height:20
	button bt_cloth_on "associate current cloth" pos:[556,269] width:110 height:20
	button bt_cloth_off "remove cloth" pos:[675,269] width:110 height:20
	label lbl1 "Watch the script listener(F11) for checking results." pos:[577,50] width:192 height:34
	editText ed_rb_name "name" pos:[37,230] width:200 height:17
	editText ed_ID_rb "ID" pos:[38,253] width:200 height:17 enabled:false
	editText ed_type_rb "" text:gAryMtlTypeNames[EM_RB] pos:[35,276] width:100 height:41 readonly:true
	dropDownList ddl_sub_rb "sub-group type" pos:[144,276] width:100 height:41 items:gAryRBSubGroupNames
	spinner sp_d_rb "density" pos:[42,347] width:200 height:16 range:[0,100,0]
	spinner sp_m_rb "mass" pos:[42,375] width:200 height:16 range:[0,100,0]
	spinner sp_sf_rb "static friction" pos:[52,403] width:190 height:16 range:[0,100,0]
	spinner sp_df_rb "dynamic friction" pos:[57,429] width:185 height:16 range:[0,100,0]
	spinner sp_b_rb "bounciness" pos:[42,456] width:200 height:16 range:[0,100,0]
	spinner sp_mdb_cl "max distance bias" pos:[332,435] width:200 height:16 range:[0,100,0]
	spinner sp_sct_cl "self collide thickness" pos:[342,460] width:190 height:16 range:[0,100,0]
	spinner sp_bf_cl "bending stiffness" pos:[332,386] width:200 height:16 range:[0,100,0]
	spinner sp_dc_cl "damping coefficient" pos:[342,411] width:190 height:16 range:[0,100,0]
	spinner sp_f_cl "friction" pos:[320,362] width:70 height:16 range:[0,100,0]
	spinner sp_sf_cl "stretch stiffness" pos:[457,362] width:70 height:16 range:[0,100,0]
	spinner sp_as_cl "anti stretch" pos:[330,339] width:70 height:16 range:[0,100,0]
	spinner sp_d_cl "density" pos:[442,339] width:80 height:16 range:[0,100,0]
	editText ed_cl_name "name" pos:[307,231] width:200 height:17
	editText ed_ID_cl "ID" pos:[307,254] width:200 height:17 enabled:false
	edittext ed_type_cl "" text:gAryMtlTypeNames[EM_CLOTH] pos:[305,277] width:100 height:41 readonly:true
	dropDownList ddl_sub_cl "sub-group type" pos:[413,276] width:100 height:41 items:gAryClothSubGroupNames
	spinner sp_asf_cl "anti strech factor" pos:[332,485] width:200 height:16 range:[0,100,0]
	button bt_create_cloth "create cloth material" pos:[128,543] width:110 height:18
	button bt_apply_cloth "apply cloth changes" pos:[368,543] width:110 height:18
	
	--UI logic functions.
	
	--Search specified myl ID in specified mtl set(global/native)
	/*!
	if found, return the PxMtl instance.
	if not found, return undefined
	*/
	fn searchMtlbyID iArySet iID = 
	(
		if iArySet==#() or iID=="" then undefined
		else
		(
			ret = undefined
			for i in iArySet do
			(
				if i._mtlID == iID then
				(
					ret = i
					exit
				)
			)
			ret
		)
	)
	
	--Load global mtls in UI.
	fn UIloadMtlsGlobal = 
	(
		if g_PxMtlManager._aryGlobalMtls == #() then false
		else
		(
			aryItems = #()
			for i in g_PxMtlManager._aryGlobalMtls do
			(
				append aryItems i._mtlID
			)
			
			lb_global.items = aryItems
			true
		)
	)
	
	--Load native mtls in UI.
	fn UIloadMtlsNative = 
	(
		if g_PxMtlManager._aryNativeMtls == #() then false
		else
		(
			aryItems = #()
			for i in g_PxMtlManager._aryNativeMtls do
			(
				append aryItems i._mtlID
			)
			
			lb_native.items = aryItems
			true
		)
	)
	
	--Set data members in RB UI.
	/*!
	All data type should match the require, can't pass just string.
	*/
	fn UISetRBData iName iID iType iSub iDensity iMass iSF iDF iB = 
	(
		ed_rb_name.text = iName
		ed_ID_rb.text = iID
		ddl_sub_rb.selection = iSub
		
		sp_d_rb.value = iDensity
		sp_m_rb.value = iMass
		sp_sf_rb.value = iSF
		sp_df_rb.value = iDF
		sp_b_rb.value = iB
	)
	
	--Set data members in Cloth UI.
	/*!
	All data type should match the require, can't pass just string.
	*/
	fn UISetClothData iName iID iType iSub iAS iD iFriction iSS iBS iDC iMDB iST iAF = 
	(
		ed_cl_name.text = iName
		ed_ID_cl.text = iID
		ddl_sub_cl.selection = iSub
		
		sp_as_cl.value = iAS
		sp_d_cl.value = iD
		sp_f_cl.value = iFriction
		sp_sf_cl.value = iSS
		sp_bf_cl.value = iBS
		sp_dc_cl.value = iDC 
		sp_mdb_cl.value = iMDB
		sp_sct_cl.value = iST
		sp_asf_cl.value = iAF
	)
	
	--Set all RB UI widgets Indeterminate.
	fn UISetRBIndeterminate = 
	(
		ed_rb_name.text = ""
		ed_ID_rb.text = ""
		--ddl_sub_rb.Indeterminate = true
		
		sp_d_rb.Indeterminate = true
		sp_m_rb.Indeterminate = true
		sp_sf_rb.Indeterminate = true
		sp_df_rb.Indeterminate = true
		sp_b_rb.Indeterminate = true
	)
	
	--Set all Cloth UI widgets Indeterminate.
	fn UISetClothIndeterminate = 
	(
		ed_cl_name.text = ""
		ed_ID_cl.text = ""
		--ddl_sub_cl.Indeterminate = true
		
		sp_as_cl.Indeterminate = true
		sp_d_cl.Indeterminate = true
		sp_f_cl.Indeterminate = true
		sp_sf_cl.Indeterminate = true
		sp_bf_cl.Indeterminate = true
		sp_dc_cl.Indeterminate = true
		sp_mdb_cl.Indeterminate = true
		sp_sct_cl.Indeterminate = true
		sp_asf_cl.Indeterminate = true
	)
	
	--Create an native RB material from the UI.
	fn CreateRBMtl = 
	(
		if TestUI.open==false then undefined
		else
		(
			--Fill in material type data.
			rbMtl = PxRBMtl()
			rbMtl._density = sp_d_rb.value
			rbMtl._mass = sp_m_rb.value 
			rbMtl._staticFriction = sp_sf_rb.value 
			rbMtl._dynamicFriction = sp_df_rb.value
			rbMtl._bounciness = sp_b_rb.value
				
			--Create material.
			newMtl = PxMtl()
			newMtl._mtlType = EM_RB 
			newMtl._category = ddl_sub_rb.selection 
			newMtl._name = ed_rb_name.text
				
			newMtl._mtlID = GenMtlID()
			newMtl._bEditable = true
			newMtl._data = rbMtl
				
			newMtl
		)
	)
	
	--Create an native Cloth material from the UI.
	fn CreateClothMtl = 
	(
		if TestUI.open==false then undefined
		else
		(
			--Fill in material type data.
			clMtl = PxClothMtl()
			clMtl._antiStretch = sp_as_cl.value
			clMtl._density = sp_d_cl.value
			clMtl._friction = sp_f_cl.value
			clMtl._stretchStiffness = sp_sf_cl.value
			clMtl._bendingStiffness = sp_bf_cl.value
			clMtl._dampingCoefficient = sp_dc_cl.value
			clMtl._maxDistanceBias = sp_mdb_cl.value
			clMtl._selfCollideThickness = sp_sct_cl.value
			clMtl._antiStretchFactor = sp_asf_cl.value
				
			--Create material.
			newMtl = PxMtl()
			newMtl._mtlType = EM_CLOTH
			newMtl._category = ddl_sub_cl.selection 
			newMtl._name = ed_cl_name.text
				
			newMtl._mtlID = GenMtlID()
			newMtl._bEditable = true
			newMtl._data = clMtl
				
			newMtl
		)
	)
	
	--Event handlers.
	on TestUI open do
	(
		UIloadMtlsGlobal()
		UIloadMtlsNative()
		lb_native.selection==0
		lb_global.selection==0
		UISetClothIndeterminate()
		UISetRBIndeterminate()
	)
	
	on lb_global selected i do
	(
		lb_native.selection = 0
		local iMtl = searchMtlbyID g_PxMtlManager._aryGlobalMtls lb_global.items[i]
		
		if iMtl!= undefined do
		(
			case iMtl._mtlType of
			(
				EM_RB:
				(
					UISetClothIndeterminate()
					
					UISetRBData iMtl._name iMtl._mtlID iMtl._mtlType iMtl._category \
					iMtl._data._density iMtl._data._mass iMtl._data._staticFriction iMtl._data._dynamicFriction iMtl._data._bounciness
				)
				
				EM_CLOTH:
				(
					UISetRBIndeterminate()
					
					UISetClothData iMtl._name iMtl._mtlID iMtl._mtlType iMtl._category \
					iMtl._data._antiStretch iMtl._data._density iMtl._data._friction iMtl._data._stretchStiffness iMtl._data._bendingStiffness \
					iMtl._data._dampingCoefficient iMtl._data._maxDistanceBias iMtl._data._selfCollideThickness iMtl._data._antiStretchFactor
				)
			)
		)
	)
	
	on lb_native selected i do
	(
		lb_global.selection = 0
		local iMtl = searchMtlbyID g_PxMtlManager._aryNativeMtls lb_native.items[i]
		
		if iMtl!= undefined do
		(
			case iMtl._mtlType of
			(
				EM_RB:
				(
					UISetClothIndeterminate()
					
					UISetRBData iMtl._name iMtl._mtlID iMtl._mtlType iMtl._category \
					iMtl._data._density iMtl._data._mass iMtl._data._staticFriction iMtl._data._dynamicFriction iMtl._data._bounciness
				)
				
				EM_CLOTH:
				(
					UISetRBIndeterminate()
					
					UISetClothData iMtl._name iMtl._mtlID iMtl._mtlType iMtl._category \
					iMtl._data._antiStretch iMtl._data._density iMtl._data._friction iMtl._data._stretchStiffness iMtl._data._bendingStiffness \
					iMtl._data._dampingCoefficient iMtl._data._maxDistanceBias iMtl._data._selfCollideThickness iMtl._data._antiStretchFactor
				)
			)
		)
	)
	
	on bt_create_rb pressed do
	(
		if \
		ed_rb_name.text=="" or \
		ddl_sub_rb.selection==0 or \
		
		sp_d_rb.indeterminate==true or \
		sp_m_rb.indeterminate==true or \
		sp_sf_rb.indeterminate==true or \
		sp_df_rb.indeterminate==true or \
		sp_b_rb.indeterminate==true then
		(
			messagebox "please fill in each blank!"
			false
		)
		else
		(
			newMtl = CreateRBMtl()
			
			--Save new created material in PhysX material data manager.
			append g_PxMtlManager._aryNativeMtls newMtl
			
			--Save in current *.max file.
			newMtl.SaveInCurMaxFile()
			
			--Add an new line in native mtl list box
			aryItems = lb_native.items
			append aryItems newMtl._mtlID
			lb_native.items = aryItems
			
			messagebox "material created!"
			true
		)
	)
	
	on bt_create_cloth pressed do
	(
		if \
		ed_cl_name.text=="" or \
		ddl_sub_cl.selection==0 or \
		
		sp_as_cl.indeterminate==true or \
		sp_d_cl.indeterminate==true or \
		sp_f_cl.indeterminate==true or \
		sp_sf_cl.indeterminate==true or \
		sp_bf_cl.indeterminate==true or \
		sp_dc_cl.indeterminate==true or \
		sp_mdb_cl.indeterminate==true or \
		sp_sct_cl.indeterminate==true or \
		sp_asf_cl.indeterminate==true then
		(
			messagebox "please fill in each blank!"
			false
		)
		else
		(
			newMtl = CreateClothMtl()
			
			--Save new created material in PhysX material data manager.
			append g_PxMtlManager._aryNativeMtls newMtl
			
			--Save in current *.max file.
			newMtl.SaveInCurMaxFile()
			
			--Add an new line in native mtl list box
			aryItems = lb_native.items
			append aryItems newMtl._mtlID
			lb_native.items = aryItems
			
			messagebox "material created!"
			true
		)
	)
	
	on bt_export pressed do
	(
		SaveMtlsToTBD()
	)
	
	on bt_import pressed do
	(
		local dir = nvpx.GetMaterialPath() + @"\"
		local filename = getOpenFileName caption:"Select a PhysX Material File to import"
	
		if filename==undefined  or filename=="" then false
		else
		(
			bResult = ImportMaterials bGlobal:false dir:filename
			
			aryItems = #()
			for i in g_PxMtlManager._aryNativeMtls do
			(
				append aryItems i._mtlID
			)
			
			lb_native.items = aryItems
			
			bResult
		)
	)
	
	on bt_remove pressed do
	(
		if lb_native.selection==0 do
		(
			messagebox "select a native material to remove "
			false
		)
		else if g_PxMtlManager._aryNativeMtls==0 do
		(
			messagebox "nothing  to remove"
			false
		)
		else
		(
			local strID = ""
			
			if ed_ID_rb.text=="" then 
				strID = ed_ID_cl.text
			else
				strID = ed_ID_rb.text
			
			for i in g_PxMtlManager._aryNativeMtls do
			(
				if i._mtlID==strID do
				(
					i.RemoveInCurMaxFile()
					exit
				)
			)
			
			g_PxMtlManager.RemoveMtlInNativeSet strID
			UIloadMtlsNative()
			UISetRBIndeterminate()
			UISetClothIndeterminate()
			lb_native.selection = 0
			
			true
		)
	)
	
	on bt_apply_rb pressed do
	(
		if lb_native.selection==0 or ed_ID_rb.text=="" do
		(
			messagebox "select a material to modify"
			false
		)
		else
		(
			ret = false
			for i in g_PxMtlManager._aryNativeMtls do
			(
				if i._mtlID == ed_ID_rb.text do
				(
					i._data._density = sp_d_rb.value
					i._data._mass = sp_m_rb.value 
					i._data._staticFriction = sp_sf_rb.value 
					i._data._dynamicFriction = sp_df_rb.value
					i._data._bounciness = sp_b_rb.value
				
					i._category = ddl_sub_rb.selection 
					i._name = ed_rb_name.text
					
					i.ApplyInCurMaxFile()
					
					messagebox "material modified"
					ret = true
					exit
				)
			)
			ret
		)
	)
	
	on bt_apply_cloth pressed do
	(
		if lb_native.selection==0 or ed_ID_cl.text=="" do
		(
			messagebox "select a material to modify"
			false
		)
		else
		(
			ret = false
			for i in g_PxMtlManager._aryNativeMtls do
			(
				if i._mtlID == ed_ID_cl.text do
				(
					i._data._antiStretch = sp_as_cl.value
					i._data._density = sp_d_cl.value
					i._data._friction = sp_f_cl.value
					i._data._stretchStiffness = sp_sf_cl.value
					i._data._bendingStiffness = sp_bf_cl.value
					i._data._dampingCoefficient = sp_dc_cl.value
					i._data._maxDistanceBias = sp_mdb_cl.value
					i._data._selfCollideThickness = sp_sct_cl.value
					i._data._antiStretchFactor = sp_asf_cl.value
				
					i._category = ddl_sub_cl.selection 
					i._name = ed_cl_name.text
					
					i.ApplyInCurMaxFile()
					
					messagebox "material modified"
					ret = true
					exit
				) 
			)
			ret
		)
	)
)

--Create PhysX Material Editor Dialog.
--This is for testing only. If any one wanna preview the Material's editor, just call this func in F11 window[HP]
fn CreatePhysXMtlEditorDlg = 
(	
	--Load previous saved materials.
	ImportMaterials()
	LoadAllNativeMtls()
	
	CreateDialog TestUI 800 600
)